<?php
/* --------------------------------------------------------------
  ot_coupon.php 2020-04-08
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2018 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------


  based on:
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2002-2003 osCommerce(ot_coupon.php,v 1.1.2.37.3); www.oscommerce.com
  (c) 2003 XT-Commerce - community made shopping http://www.xt-commerce.com ($Id: ot_coupon.php 1322 2005-10-27 13:58:22Z mz $)

  Released under the GNU General Public License
  -----------------------------------------------------------------------------------------
  Third Party contributions:

  Credit Class/Gift Vouchers/Discount Coupons (Version 5.10)
  http://www.oscommerce.com/community/contributions,282
  Copyright (c) Strider | Strider@oscworks.com
  Copyright (c  Nick Stanko of UkiDev.com, nick@ukidev.com
  Copyright (c) Andre ambidex@gmx.net
  Copyright (c) 2001,2002 Ian C Wilson http://www.phesis.org

  Released under the GNU General Public License
  --------------------------------------------------------------------------------------- */

require_once(DIR_FS_INC . 'xtc_get_currencies_values.inc.php');

class ot_coupon_ORIGIN
{
	public $code;
	public $header;
	public $title;
	public $description;
	public $user_prompt;
	public $enabled;
	public $sort_order;
	public $include_shipping;
	public $include_tax;
	public $calculate_tax;
	public $tax_class;
	public $credit_class;
	public $output;
	public $deduction;
	public $coupon_code;

	public function __construct()
	{
		$this->code = 'ot_coupon';
		$this->header = defined('MODULE_ORDER_TOTAL_COUPON_HEADER') ? MODULE_ORDER_TOTAL_COUPON_HEADER : '';
		$this->title = defined('MODULE_ORDER_TOTAL_COUPON_TITLE') ? MODULE_ORDER_TOTAL_COUPON_TITLE : '';
		$this->description = defined('MODULE_ORDER_TOTAL_COUPON_DESCRIPTION') ? MODULE_ORDER_TOTAL_COUPON_DESCRIPTION : '';
		$this->user_prompt = '';
		$this->enabled = defined('MODULE_ORDER_TOTAL_COUPON_STATUS') ? MODULE_ORDER_TOTAL_COUPON_STATUS : 'false';
		$this->sort_order = defined('MODULE_ORDER_TOTAL_COUPON_SORT_ORDER') ? MODULE_ORDER_TOTAL_COUPON_SORT_ORDER : '0';
		$this->include_shipping = defined('MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING') ? MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING : 'false';
		$this->include_tax = defined('MODULE_ORDER_TOTAL_COUPON_INC_TAX') ? MODULE_ORDER_TOTAL_COUPON_INC_TAX : 'true';
		$this->calculate_tax = defined('MODULE_ORDER_TOTAL_COUPON_CALC_TAX') ? MODULE_ORDER_TOTAL_COUPON_CALC_TAX : 'true';
		$this->tax_class = defined('MODULE_ORDER_TOTAL_COUPON_TAX_CLASS') ? MODULE_ORDER_TOTAL_COUPON_TAX_CLASS : '0';
		$this->credit_class = true;
        $this->output = [];
        
        $positionOtCoupon   = strpos(MODULE_ORDER_TOTAL_INSTALLED, $this->code);
        $positionOtShipping = strpos(MODULE_ORDER_TOTAL_INSTALLED, 'ot_shipping.php');
        if ($positionOtCoupon < $positionOtShipping) {
            $this->include_shipping = 'false';
        } else {
            $this->include_shipping = 'true';
        }
        $db = StaticGXCoreLoader::getDatabaseQueryBuilder();
        $db->update(
            'gx_configurations',
            ['value' => $this->include_shipping],
            ['key' => 'configuration/MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING']
        );
    }
    
    
    protected function getCouponDetails(IdType $couponID): ?array
    {
        $db = StaticGXCoreLoader::getDatabaseQueryBuilder();
        $couponRow = $db->get_where('coupons', ['coupon_id' => $couponID->asInt()])->row_array();
        return $couponRow;
    }
    

    public function process(): void
    {
        $order   = $GLOBALS['order'];
        $xtPrice = $GLOBALS['xtPrice'];
        
        if (!isset($_SESSION['cc_id'])) {
            return;
        }
        $couponId = new IdType((int)$_SESSION['cc_id']);
        $couponDetails = $this->getCouponDetails($couponId);
        if ($couponDetails['coupon_active'] !== 'Y') {
            return;
        }
    
        $order_total     = $this->get_order_total();
        $od_amount       = $this->calculate_credit($order_total);
        $tod_amount      = 0.0;
        $this->deduction = $od_amount;
        
        if(strtolower($this->calculate_tax) !== 'none')
        {
            $tod_amount = $this->calculate_tax_deduction($order_total, $this->deduction, $this->calculate_tax);
        }
    
        if($od_amount > 0)
        {
            if($couponDetails['coupon_type'] !== 'P' && (int)$_SESSION['customers_status']['customers_status_show_price_tax'] === 0)
            {
                $od_amount -= $tod_amount;
            }
    
            $order->info['subtotal']  -= round($od_amount, 2);
            $order->info['total']     -= round($od_amount, 2);
            $order->info['deduction'] = $od_amount;

            $quotedCode = $this->addQuotes(new NonEmptyStringType($this->coupon_code), new LanguageCode(new StringType($_SESSION['language_code'])));
            $this->output[]           = [
                'title' => sprintf('%s %s:', $this->title, $quotedCode),
                'text'  => '-' . $xtPrice->xtcFormat($od_amount, true),
                'value' => $od_amount * -1,
            ];
        }
	}
	
	protected function addQuotes(NonEmptyStringType $input, LanguageCode $languageCode): string
    {
        if ($languageCode->asString() === 'de') {
            $openingQuotationMark = '„';
            $closingQuotationMark = '“';
        } elseif ($languageCode->asString() === 'en') {
            $openingQuotationMark = '“';
            $closingQuotationMark = '”';
        } else {
            $openingQuotationMark = '"';
            $closingQuotationMark = '"';
        }
    
        return $openingQuotationMark . $input->asString() . $closingQuotationMark;
    }
    
    
    public function selection_test()
    {
        return false;
    }
    
    
    public function pre_confirmation_check($order_total)
    {
        return $this->calculate_credit($order_total);
    }
    
    
    public function use_credit_amount()
    {
        return '';
    }
    
    
    public function credit_selection()
    {
        return false;
    }
    
    
    public function collect_posts()
    {
        return;
        // processing for $_POST['gv_redeem_code'] used to be here; not used anymore.
    }
    
    protected function parseIdList(string $idListString): array
    {
        $idListString = preg_replace('/[^0-9,]/', '', $idListString);
        $idList = explode(',', $idListString);
        $idList = array_filter($idList);
        $idList = array_unique($idList);
        $idList = array_map(static function($element) { return (int)$element; }, $idList);
        return $idList;
    }
    
    protected function getProductCategoriesIds(IdType $productsId): array
    {
        $db = StaticGXCoreLoader::getDatabaseQueryBuilder();
        $productCategoriesIds = [];
        $categoriesRow = $db->get_where('categories_index', ['products_id' => $productsId->asInt()])->row_array();
        if (!empty($categoriesRow)) {
            preg_match_all('-(\d+)-', $categoriesRow['categories_index'], $matches);
            foreach ($matches[1] as $categoryId) {
                if ((int)$categoryId !== 0) {
                    $productCategoriesIds[] = (int)$categoryId;
                }
            }
        }
        
        return $productCategoriesIds;
    }
    
    public function calculate_credit($amount)
    {
        $order = $GLOBALS['order'];
        
        if (!isset($_SESSION['cc_id'])) {
            return 0;
        }
        
        $couponDetails = $this->getCouponDetails(new IdType((int)$_SESSION['cc_id']));
        if (empty($couponDetails)) {
            return 0;
        }

        $t_order_total     = $this->get_order_total();
        $this->coupon_code = $couponDetails['coupon_code'];
        $c_deduct          = $couponDetails['coupon_amount'];
    
        $t_gm_currency_array = xtc_get_currencies_values($_SESSION['currency']);
        $currencyFactor = !empty($t_gm_currency_array['value']) ? (float)$t_gm_currency_array['value'] : 1;
    
        if ($couponDetails['coupon_type'] !== 'P') {
            $c_deduct = round($c_deduct * $currencyFactor, 2);
        }
    
        $minimumOrderValue = round($couponDetails['coupon_minimum_order'] * $currencyFactor, 2);
        if ($minimumOrderValue > $t_order_total) {
            return 0;
        }
    
        $od_amount = 0;

        $restrictToProductIds = $this->parseIdList($couponDetails['restrict_to_products']);
        $restrictToCategoriesIds = $this->parseIdList($couponDetails['restrict_to_categories']);
        if (!empty($restrictToProductIds || !empty($restrictToCategoriesIds))) {
            $restrictedProductTotal = 0.0;
            foreach($order->products as $orderProduct) {
                if (!empty($restrictToProductIds)) {
                    foreach ($restrictToProductIds as $productId) {
                        if ((int)$productId === (int)xtc_get_prid($orderProduct['id'])) {
                            if ($couponDetails['coupon_type'] === 'P') {
                                $pr_c       = $this->product_price($orderProduct['id']);
                                $pod_amount = round($pr_c * 100) / 100 * $c_deduct / 100;
                                $od_amount  += $pod_amount;
                            } else {
                                $restrictedProductTotal += $this->product_price($orderProduct['id']);
                                if ($restrictedProductTotal < $c_deduct) {
                                    $od_amount = $restrictedProductTotal;
                                } else {
                                    $od_amount = $c_deduct;
                                }
                            }
                        }
                    }
                } else {
                    $productsId = xtc_get_prid($orderProduct['id']);
                    $productCategories = $this->getProductCategoriesIds(new IdType((int)$productsId));
                    $categoriesIntersect = array_intersect($productCategories, $restrictToCategoriesIds);
                    if (!empty($categoriesIntersect)) {
                        if ($couponDetails['coupon_type'] === 'P') {
                            $pr_c       = $this->product_price($orderProduct['id']);
                            $pod_amount = round($pr_c * 100) / 100 * $c_deduct / 100;
                            $od_amount  += $pod_amount;
                        } else {
                            $restrictedProductTotal += $this->product_price($orderProduct['id']);
    
                            if ($restrictedProductTotal < $c_deduct) {
                                $od_amount = $restrictedProductTotal;
                            } else {
                                $od_amount = $c_deduct;
                            }
                        }
                    }
                }
            }
        } elseif ($couponDetails['coupon_type'] !== 'P') { // types F (fixed) and S (shipping)
            $od_amount = $c_deduct;
        } else { // type P (percentage)
            $od_amount = $amount * $couponDetails['coupon_amount'] / 100;
        }
        
        if ($couponDetails['coupon_type'] === 'S') {
            $od_amount += $order->info['shipping_cost'];
        }
        
        if ($od_amount > $amount) {
            if ($couponDetails['coupon_type'] === 'S') {
                if (strtolower($this->include_shipping) === 'true') {
                    $amount -= $order->info['shipping_cost'];
                }
    
                if ($od_amount > ($amount + $order->info['shipping_cost'])) {
                    $od_amount = $amount + $order->info['shipping_cost'];
                }
            } else {
                $od_amount = $amount;
            }
        }
        
        return $od_amount;
    }
    
    
    public function calculate_tax_deduction($amount, $od_amount, $method)
	{
        $order                     = $GLOBALS['order'];
        $coo_gm_main               = new main();
        $t_gm_tax_before_deduction = $order->info['tax'];
        $shipping_tax_reduction    = 0;
        $shipping_costs_reduction  = 0;
        $shipping_tax_rate         = 0;
        $shipping_tax_desc         = '';
        $total_price               = 0;
        $total_price_incl_tax      = 0;
        
        $taxDescPrefix = $_SESSION['customers_status']['customers_status_show_price_tax'] === '1' ? TAX_ADD_TAX : TAX_NO_TAX;
        
        if (isset($order->info['shipping_class']) && !empty($order->info['shipping_class'])) {
            $shipping_class_name = explode('_', $order->info['shipping_class'])[0];
            
            if (isset($GLOBALS[$shipping_class_name], $GLOBALS[$shipping_class_name]->tax_class)) {
                $shipping_tax_class_id = $GLOBALS[$shipping_class_name]->tax_class;
            } elseif (defined('MODULE_SHIPPING_' . strtoupper($shipping_class_name) . '_TAX_CLASS')) {
                $shipping_tax_class_id = constant('MODULE_SHIPPING_' . strtoupper($shipping_class_name) . '_TAX_CLASS');
            }
            if (isset($shipping_tax_class_id)) {
                $shipping_tax_rate     = xtc_get_tax_rate(
                    $shipping_tax_class_id,
                    $order->delivery['country']['id'],
                    $order->delivery['zone_id']
                );
                
                $shipping_tax_desc .= $taxDescPrefix . xtc_get_tax_description(
                    $shipping_tax_class_id,
                    $order->delivery['country']['id'],
                    $order->delivery['zone_id']
                );
            }
        }
        
        $couponDetails = $this->getCouponDetails(new IdType((int)$_SESSION['cc_id']));
        if (!empty($couponDetails)) {
			// RESTRICTION --------------------------------
            $restrictToProductIds = $this->parseIdList($couponDetails['restrict_to_products']);
            $restrictToCategoriesIds = $this->parseIdList($couponDetails['restrict_to_categories']);
            if (!empty($restrictToProductIds) || !empty($restrictToCategoriesIds)) {
                // What to do here.
				// Loop through all products and build a list of all product_ids, price, tax class
				// at the same time create total net amount.
				// then
				// for percentage discounts. simply reduce tax group per product by discount percentage
				// or
				// for fixed payment amount
				// calculate ratio based on total net
				// for each product reduce tax group per product by ratio amount.
				$products = $_SESSION['cart']->get_products();

				$valid_product = false;
				$valid_array = array();
    
                for ($productsIndex = 0, $productsIndexMax = sizeof($products); $productsIndex < $productsIndexMax; $productsIndex++) {
                    $valid_product = false;
        
                    $t_prid    = xtc_get_prid($products[$productsIndex]['id']);
                    $cc_query  = xtc_db_query(
                        "SELECT products_tax_class_id FROM " . TABLE_PRODUCTS . " WHERE products_id = '" . $t_prid . "'"
                    );
                    $cc_result = xtc_db_fetch_array($cc_query);
        
                    if ($couponDetails['restrict_to_products']) {
                        $pr_ids = explode(',', $couponDetails['restrict_to_products']);
                        for ($p = 0, $pMax = sizeof($pr_ids); $p < $pMax; $p++) {
                            if ($pr_ids[$p] == $t_prid) {
                                $valid_product = true;
                            }
                        }
                    }
        
                    if ($couponDetails['restrict_to_categories']) {
                        // v5.13a Tanaka 2005-4-30:  New code, this correctly identifies valid products in subcategories
                        $cat_ids = explode(',', $couponDetails['restrict_to_categories']);
            
                        $sub_cat_ids = [];
            
                        $t_sql    = 'SELECT categories_index FROM categories_index WHERE products_id = "' . $t_prid
                                    . '"';
                        $t_result = xtc_db_query($t_sql);
            
                        if (xtc_db_num_rows($t_result) === 1) {
                            $t_row = xtc_db_fetch_array($t_result);
                            preg_match_all('-(\d+)-', $t_row['categories_index'], $t_matches);
                            foreach ($t_matches[1] AS $t_products_category_id) {
                                if ((int)$t_products_category_id !== 0) {
                                    $sub_cat_ids[] = $t_products_category_id;
                                }
                            }
                        }
            
                        for ($iii = 0, $iiiMax = count($sub_cat_ids); $iii < $iiiMax; $iii++) {
                            for ($ii = 0, $iiMax = count($cat_ids); $ii < $iiMax; $ii++) {
                                if ((int)$sub_cat_ids[$iii] === (int)$cat_ids[$ii]) {
                                    $valid_product = true;
                                    continue 2;
                                }
                            }
                        }
                    }
        
                    if ($valid_product) {
                        $price_excl_vat       = $products[$productsIndex]['final_price']
                                                * $products[$productsIndex]['quantity'];
                        $valid_array[]        = [
                            'product_id'         => $t_prid,
                            'products_price'     => $price_excl_vat,
                            'products_tax_class' => $cc_result['products_tax_class_id'],
                        ];
                        $total_price          += $price_excl_vat;
                        $tax_rate             = xtc_get_tax_rate(
                            $cc_result['products_tax_class_id'],
                            $order->delivery['country']['id'],
                            $order->delivery['zone_id']
                        );
                        $total_price_incl_tax += $price_excl_vat * (100 + $tax_rate) / 100;
                    }
                }
    
                if (sizeof($valid_array) > 0)
				{
                    if ($method === 'Credit Note') {
                        $tax_rate = xtc_get_tax_rate(
                            $this->tax_class,
                            $order->delivery['country']['id'],
                            $order->delivery['zone_id']
                        );
                        
                        $tax_desc = $taxDescPrefix . xtc_get_tax_description(
                            $this->tax_class,
                            $order->delivery['country']['id'],
                            $order->delivery['zone_id']
                        );
                        
                        if ($couponDetails['coupon_type'] === 'S') {
                            $t_gm_od_amount         = $od_amount - $order->info['shipping_cost'];
                            $t_gm_shipping_tax_rate = ($order->info['shipping_cost'] / $_SESSION['shipping']['cost']
                                                       - 1) * 100;
                            
                            $shipping_tax_class_id  = constant(
                                'MODULE_SHIPPING_' . strtoupper($shipping_class_name) . '_TAX_CLASS'
                            );

                            $t_gm_shipping_tax_desc = $taxDescPrefix . xtc_get_tax_description(
                                $shipping_tax_class_id,
                                $order->delivery['country']['id'],
                                $order->delivery['zone_id']
                            );
    
                            $order->info['tax_groups'][$t_gm_shipping_tax_desc] -= ((($order->info['shipping_cost'] / (1
                                                                                                                       + $t_gm_shipping_tax_rate
                                                                                                                         / 100))
                                                                                     - $order->info['shipping_cost'])
                                                                                    * (-1));
                            $order->info['tax']                                 -= ((($order->info['shipping_cost'] / (1
                                                                                                                       + $t_gm_shipping_tax_rate
                                                                                                                         / 100))
                                                                                     - $order->info['shipping_cost'])
                                                                                    * (-1));
                        } else {
                            $t_gm_od_amount = $od_amount;
                        }
    
                        $order->info['tax_groups'][$tax_desc] -= ((($t_gm_od_amount / (1 + $tax_rate / 100))
                                                                   - $t_gm_od_amount) * (-1));
                        $order->info['tax']                   -= ((($t_gm_od_amount / (1 + $tax_rate / 100))
                                                                   - $t_gm_od_amount) * (-1));
                    } else {
                        $t_gm_od_amount = $od_amount;
    
                        if ($couponDetails['coupon_type'] === 'S'
                            && (((int)$_SESSION['customers_status']['customers_status_show_price_tax'] === 1
                                 && $_SESSION['shipping']['cost'] * (1 + ($shipping_tax_rate / 100))
                                    === (float)$order->info['shipping_cost'])
                                || ((int)$_SESSION['customers_status']['customers_status_show_price_tax'] === 0
                                   && (float)$_SESSION['shipping']['cost'] === (float)$order->info['shipping_cost']))) {
                            $shipping_tax_reduction                        = $_SESSION['shipping']['cost']
                                                                             * ($shipping_tax_rate / 100);
                            $order->info['tax_groups'][$shipping_tax_desc] -= $shipping_tax_reduction;
                            $order->info['tax']                            -= $shipping_tax_reduction;
                            $shipping_costs_reduction                      = $order->info['shipping_cost'];
                            $t_gm_od_amount                                = $od_amount - $order->info['shipping_cost'];
                        }
    
                        for ($p = 0, $pMax = sizeof($valid_array); $p < $pMax; $p++) {
                            $tax_rate = xtc_get_tax_rate(
                                $valid_array[$p]['products_tax_class'],
                                $order->delivery['country']['id'],
                                $order->delivery['zone_id']
                            );
                            
                            $tax_desc = $taxDescPrefix . xtc_get_tax_description(
                                $valid_array[$p]['products_tax_class'],
                                $order->delivery['country']['id'],
                                $order->delivery['zone_id']
                            );
        
                            if ($_SESSION['customers_status']['customers_status_show_price_tax'] === '0') {
                                $t_gm_ratio = ((100 / $total_price_incl_tax) * ($valid_array[$p]['products_price'] * (1
                                                                                                                      + ($tax_rate
                                                                                                                         / 100))))
                                              / 100;
                            } else {
                                $t_gm_ratio = ((100 / $total_price) * $valid_array[$p]['products_price']) / 100;
                            }
        
                            if ($tax_rate > 0) {
                                if ($_SESSION['customers_status']['customers_status_show_price_tax'] === '1') {
                                    $t_gm_original_net_price = $valid_array[$p]['products_price'] / ((100 + $tax_rate)
                                                                                                     / 100);
                                    $t_gm_original_tax_value = $t_gm_original_net_price * $tax_rate / 100;
                
                                    $t_gm_gross_discount_ratio = $t_gm_od_amount * $t_gm_ratio;
                
                                    $t_gm_reduced_price     = $valid_array[$p]['products_price']
                                                              - $t_gm_gross_discount_ratio;
                                    $t_gm_reduced_net_price = $t_gm_reduced_price / ((100 + $tax_rate) / 100);
                                    $t_gm_reduced_price_tax = $t_gm_reduced_net_price * $tax_rate / 100;
                
                                    $t_gm_reduce_tax = $t_gm_original_tax_value - $t_gm_reduced_price_tax;
                                } else {
                                    $t_gm_net_discount_ratio = $t_gm_od_amount * $t_gm_ratio;
                                    $t_gm_reduced_price      = $valid_array[$p]['products_price']
                                                               - $t_gm_net_discount_ratio;
                                    $t_gm_reduced_price_tax  = $t_gm_reduced_price * ($tax_rate / 100);
                                    $t_gm_reduce_tax         = ($valid_array[$p]['products_price'] * ($tax_rate / 100))
                                                               - $t_gm_reduced_price_tax;
                                }
            
                                $order->info['tax_groups'][$tax_desc] -= $t_gm_reduce_tax;
                                $order->info['tax']                   -= $t_gm_reduce_tax;
            
                                if ($order->info['tax_groups'][$tax_desc] < 0.005) {
                                    $order->info['tax_groups'][$tax_desc] = 0;
                                }
                                if ($order->info['tax'] < 0.005) {
                                    $order->info['tax'] = 0;
                                }
                            }
                        }
                    }
                }
			}
			else //NO RESTRICTION--------------------------------
			{
                if ($couponDetails['coupon_type'] === 'F' || $couponDetails['coupon_type'] === 'S') {
                    $tod_amount = 0;
                    
                    if ($method === 'Credit Note') {
                        $tax_rate = xtc_get_tax_rate(
                            $this->tax_class,
                            $order->delivery['country']['id'],
                            $order->delivery['zone_id']
                        );
                        
                        if ($_SESSION['customers_status']['customers_status_show_price_tax'] == '1') {
                            $tax_desc = TAX_ADD_TAX;
                        } else {
                            $tax_desc = TAX_NO_TAX;
                        }
                        
                        $tax_desc .= xtc_get_tax_description(
                            $this->tax_class,
                            $order->delivery['country']['id'],
                            $order->delivery['zone_id']
                        );
                        
                        if ($couponDetails['coupon_type'] == 'S') {
                            $t_gm_od_amount         = $od_amount - $order->info['shipping_cost'];
                            $t_gm_shipping_tax_rate = ($order->info['shipping_cost'] / $_SESSION['shipping']['cost']
                                                       - 1) * 100;
                            
                            $shipping_tax_class_id  = constant(
                                'MODULE_SHIPPING_' . strtoupper($shipping_class_name) . '_TAX_CLASS'
                            );
                            $t_gm_shipping_tax_desc = $taxDescPrefix .  xtc_get_tax_description(
                                $shipping_tax_class_id,
                                $order->delivery['country']['id'],
                                $order->delivery['zone_id']
                            );
    
                            $order->info['tax_groups'][$t_gm_shipping_tax_desc] -= ((($order->info['shipping_cost'] / (1
                                                                                                                       + $t_gm_shipping_tax_rate
                                                                                                                         / 100))
                                                                                     - $order->info['shipping_cost'])
                                                                                    * (-1));
                            $order->info['tax']                                 -= ((($order->info['shipping_cost'] / (1
                                                                                                                       + $t_gm_shipping_tax_rate
                                                                                                                         / 100))
                                                                                     - $order->info['shipping_cost'])
                                                                                    * (-1));
                        } else {
                            $t_gm_od_amount = $od_amount;
                        }
    
                        $order->info['tax_groups'][$tax_desc] -= ((($t_gm_od_amount / (1 + $tax_rate / 100))
                                                                   - $t_gm_od_amount) * (-1));
                        $order->info['tax']                   -= ((($t_gm_od_amount / (1 + $tax_rate / 100))
                                                                   - $t_gm_od_amount) * (-1));
                    } else {
                        $_SESSION['cart']->calculate();
                        $t_gm_cart_tax  = $_SESSION['cart']->tax;
                        $t_gm_tax_class = array_keys($t_gm_cart_tax);
                        
                        $t_gm_products = [];
                        $t_gm_total    = 0;
                        
                        foreach ($t_gm_tax_class AS $t_gm_tax_class_id) {
                            foreach ($order->products as $productsIndex => $orderProduct) {
                                if ((int)$orderProduct['tax_class_id'] === (int)$t_gm_tax_class_id) {
                                    if ((int)$_SESSION['customers_status']['customers_status_show_price_tax'] === 1) {
                                        $t_gm_products[$t_gm_tax_class_id]['PRICE'] += $order->products[$productsIndex]['final_price'];
                                        $t_gm_total                                 += $order->products[$productsIndex]['final_price'];
                                    } else {
                                        $t_gm_products[$t_gm_tax_class_id]['PRICE'] += $orderProduct['final_price']
                                                                                       + $orderProduct['final_price']
                                                                                         * $orderProduct['tax'] / 100;
                                        $t_gm_total                                 += $orderProduct['final_price']
                                                                                       + $orderProduct['final_price']
                                                                                         * $orderProduct['tax'] / 100;
                                    }
                                    
                                    $t_gm_products[$t_gm_tax_class_id]['TAX_RATE'] = $order->products[$productsIndex]['tax'];
                                    
                                    $t_gm_products[$t_gm_tax_class_id]['TAX_DESC'] = $taxDescPrefix
                                                                                     . xtc_get_tax_description(
                                                                                         $orderProduct['tax_class_id'],
                                                                                         $order->delivery['country']['id'],
                                                                                         $order->delivery['zone_id']
                                                                                     );
                                }
                            }
                        }
                        
                        if ($couponDetails['coupon_type'] === 'S') {
                            $od_amount -= round($order->info['shipping_cost'], 2);
                            if ($od_amount > $t_gm_total) {
                                $od_amount = $t_gm_total;
                            }
                            if (((int)$_SESSION['customers_status']['customers_status_show_price_tax'] === 1
                                 && $_SESSION['shipping']['cost'] * (1 + ($shipping_tax_rate / 100))
                                    === $order->info['shipping_cost'])
                                || ((int)$_SESSION['customers_status']['customers_status_show_price_tax'] === 0
                                    && $_SESSION['shipping']['cost'] === $order->info['shipping_cost'])) {
                                $shipping_tax_reduction                        += $_SESSION['shipping']['cost']
                                                                                  * ($shipping_tax_rate / 100);
                                $order->info['tax_groups'][$shipping_tax_desc] -= $shipping_tax_reduction;
                                $order->info['tax']                            -= $shipping_tax_reduction;
                            }
                        }
                        
                        foreach ($t_gm_products AS $t_gm_key => $t_gm_value) {
                            $t_gm_products[$t_gm_key]['RATIO'] = (100 / $t_gm_total)
                                                                 * $t_gm_products[$t_gm_key]['PRICE'];
                            
                            if ($t_gm_products[$t_gm_key]['TAX_RATE'] != 0 && $t_gm_products[$t_gm_key]['PRICE'] != 0) {
                                $t_gm_products[$t_gm_key]['TAX'] = ((($t_gm_products[$t_gm_key]['PRICE'] / (1
                                                                                                            + $t_gm_products[$t_gm_key]['TAX_RATE']
                                                                                                              / 100))
                                                                     - $t_gm_products[$t_gm_key]['PRICE']) * (-1));
                                $t_gm_products[$t_gm_key]['TAX_AFTER_DEDUCTION'] = (((($t_gm_products[$t_gm_key]['PRICE']
                                                                                       - round(
                                                                                           $od_amount
                                                                                           * ($t_gm_products[$t_gm_key]['RATIO']
                                                                                              / 100),
                                                                                           2
                                                                                       )) / (1
                                                                                             + $t_gm_products[$t_gm_key]['TAX_RATE']
                                                                                               / 100))
                                                                                     - ($t_gm_products[$t_gm_key]['PRICE']
                                                                                        - round(
                                                                                            $od_amount
                                                                                            * ($t_gm_products[$t_gm_key]['RATIO']
                                                                                               / 100),
                                                                                            2
                                                                                        ))) * (-1));
                                $t_gm_products[$t_gm_key]['TAX_DEDUCTION'] = $t_gm_products[$t_gm_key]['TAX']
                                                                             - $t_gm_products[$t_gm_key]['TAX_AFTER_DEDUCTION'];
    
                                if ($t_gm_products[$t_gm_key]['TAX_AFTER_DEDUCTION'] < 0) {
                                    $t_gm_products[$t_gm_key]['TAX_AFTER_DEDUCTION'] = 0;
                                    $t_gm_products[$t_gm_key]['TAX_DEDUCTION']       = $t_gm_products[$t_gm_key]['TAX'];
                                }
                                
                                $order->info['tax_groups'][$t_gm_products[$t_gm_key]['TAX_DESC']] -= $t_gm_products[$t_gm_key]['TAX_DEDUCTION'];
                                $order->info['tax']                                               -= $t_gm_products[$t_gm_key]['TAX_DEDUCTION'];
                                
                                if ($_SESSION['shipping']['cost'] * (1 + ($t_gm_products[$t_gm_key]['TAX_RATE'] / 100))
                                    === (float)$order->info['shipping_cost']
                                    && $t_gm_total < $od_amount) {
                                    $shipping_costs_reduction = $od_amount - $t_gm_total;
                                    if ($shipping_costs_reduction > 0) {
                                        $t_gm_shipping_costs                                              = round(
                                            $order->info['shipping_cost'],
                                            2
                                        );
                                        $t_gm_shipping_costs_tax_old                                      = ($t_gm_shipping_costs
                                                                                                             / (1
                                                                                                                + ($t_gm_products[$t_gm_key]['TAX_RATE']
                                                                                                                   / 100))
                                                                                                             - $t_gm_shipping_costs)
                                                                                                            * (-1);
                                        $t_gm_shipping_costs                                              -= $shipping_costs_reduction;
                                        $t_gm_shipping_costs_tax_new                                      = ($t_gm_shipping_costs
                                                                                                             / (1
                                                                                                                + ($t_gm_products[$t_gm_key]['TAX_RATE']
                                                                                                                   / 100))
                                                                                                             - $t_gm_shipping_costs)
                                                                                                            * (-1);
                                        $order->info['tax_groups'][$t_gm_products[$t_gm_key]['TAX_DESC']] = $order->info['tax_groups'][$t_gm_products[$t_gm_key]['TAX_DESC']]
                                                                                                            - $t_gm_shipping_costs_tax_old
                                                                                                            + $t_gm_shipping_costs_tax_new;
                                        $order->info['tax']                                               = $order->info['tax']
                                                                                                            - $t_gm_shipping_costs_tax_old
                                                                                                            + $t_gm_shipping_costs_tax_new;
                                    } else {
                                        $order->info['tax']                                               -= $order->info['tax_groups'][$t_gm_products[$t_gm_key]['TAX_DESC']];
                                        $order->info['tax_groups'][$t_gm_products[$t_gm_key]['TAX_DESC']] = 0;
                                    }
                                }
                                
                                if ($order->info['tax_groups'][$t_gm_products[$t_gm_key]['TAX_DESC']] < 0.005) {
                                    $order->info['tax_groups'][$t_gm_products[$t_gm_key]['TAX_DESC']] = 0;
                                }
                                
                                if ($order->info['tax'] < 0.005) {
                                    $order->info['tax'] = 0;
                                }
                            } else {
                                $t_gm_products[$t_gm_key]['TAX']                 = 0;
                                $t_gm_products[$t_gm_key]['TAX_AFTER_DEDUCTION'] = 0;
                                $t_gm_products[$t_gm_key]['TAX_DEDUCTION']       = 0;
                            }
                        }
                    }
                }
                
                if ($couponDetails['coupon_type'] === 'P') {
                    $tod_amount = 0;
                    
                    if ($method === 'Credit Note') {
                        $t_gm_tax_rate = xtc_get_tax_rate(
                            $this->tax_class,
                            $order->delivery['country']['id'],
                            $order->delivery['zone_id']
                        );
                        
                        $tax_desc = $taxDescPrefix . xtc_get_tax_description(
                            $this->tax_class,
                            $order->delivery['country']['id'],
                            $order->delivery['zone_id']
                        );

                        $t_gm_od_amount = $od_amount;
                        
                        if ((int)$_SESSION['customers_status']['customers_status_show_price_tax'] === 0) {
                            $order->info['tax_groups'][$tax_desc] -= ($t_gm_od_amount * ($t_gm_tax_rate / 100));
                            $order->info['tax']                   -= ($t_gm_od_amount * ($t_gm_tax_rate / 100));
                        } else {
                            $order->info['tax_groups'][$tax_desc] -= ((($t_gm_od_amount / (1 + $t_gm_tax_rate / 100))
                                                                       - $t_gm_od_amount) * (-1));
                            $order->info['tax']                   -= ((($t_gm_od_amount / (1 + $t_gm_tax_rate / 100))
                                                                       - $t_gm_od_amount) * (-1));
                        }
                    } else {
                        $couponFactor       = (100 - $couponDetails['coupon_amount']) / 100;
                        $order->info['tax'] *= $couponFactor;
                        
                        foreach ($order->info['tax_groups'] as $key => $value) {
                            $gm_tax_class = 0;
                            
                            foreach ($_SESSION['cart']->tax AS $gm_key => $gm_value) {
                                if ($gm_value['desc'] === $key) {
                                    $gm_tax_class = $gm_key;
                                }
                            }
                            
                            $tax_rate = xtc_get_tax_rate(
                                $gm_tax_class,
                                $order->delivery['country']['id'],
                                $order->delivery['zone_id']
                            );
                            
                            if (!empty($tax_rate)) {
                                $order->info['tax_groups'][$key] *= $couponFactor;
                            }
                        }
                    }
                }
            }
		}

		if(empty($tod_amount))
		{
			$tod_amount = $t_gm_tax_before_deduction - $order->info['tax'] - $shipping_tax_reduction;
		}

		return $tod_amount;
	}
    
    
    public function update_credit_account($i)
    {
        return false;
    }
    
    
    public function apply_credit()
    {
        $insert_id = $GLOBALS['insert_id'];
        
        if ($this->deduction > 0) {
            $t_ip = '';
            if ((bool)gm_get_conf('GM_LOG_IP') === true && (bool)gm_get_conf('GM_CONFIRM_IP') === false) {
                $t_ip = xtc_get_ip_address();
            }
    
            xtc_db_query(
                "INSERT INTO " . TABLE_COUPON_REDEEM_TRACK . " (coupon_id, redeem_date, redeem_ip, customer_id, order_id)
							VALUES ('" . $_SESSION['cc_id'] . "', now(), '" . $t_ip . "', '" . $_SESSION['customer_id']
                . "', '" . $insert_id . "')"
            );
        }
        
        unset($_SESSION['cc_id']);
    }
    
    
    public function get_order_total()
	{
		$order = $GLOBALS['order'];
		$xtPrice = $GLOBALS['xtPrice'];

		$order_total = $order->info['total'];

		// Check if gift voucher is in cart and adjust total
		$products = $_SESSION['cart']->get_products();
        for ($i = 0, $sizeOfProducts = count($products); $i < $sizeOfProducts; $i++) {
            $t_prid          = xtc_get_prid($products[$i]['id']);
            $gv_query        = xtc_db_query(
                'SELECT products_tax_class_id, products_model FROM `products` WHERE products_id = ' . (int)$t_prid
            );
            $gv_result       = xtc_db_fetch_array($gv_query);
            $gv_order_amount = $order->products[$i]['final_price'];
            
            if (0 === strpos($gv_result['products_model'], 'GIFT')) {
                $qty          = $_SESSION['cart']->get_quantity($t_prid);
                
                if (strtolower($this->include_tax) === 'false') {
                    $gv_amount = $gv_order_amount * $qty;
                } else {
                    $products_tax = $xtPrice->TAX[$gv_result['products_tax_class_id']];
                    $gv_amount = ($gv_order_amount + $xtPrice->calcTax($gv_order_amount, $products_tax)) * $qty;
                }
                
                $order_total -= $gv_amount;
            }
        }
        
        if (strtolower($this->include_tax) === 'false') {
            $order_total -= $order->info['tax'];
        }
        
        if (strtolower($this->include_shipping) === 'false') {
            $order_total -= $order->info['shipping_cost'];
        }
        
        // OK thats fine for global coupons but what about restricted coupons
		// where you can only redeem against certain products/categories.
		// and I though this was going to be easy !!!
        $couponId = new IdType((int)$_SESSION['cc_id']);
        $couponDetails = $this->getCouponDetails($couponId);
		if(!empty($couponDetails))
		{
            $in_cat  = true;
            $cat_ids = $this->parseIdList($couponDetails['restrict_to_categories']);
            if (!empty($cat_ids)) {
                $in_cat = false;
                for ($i = 0, $iMax = count($cat_ids); $i < $iMax; $i++) {
                    if (is_array($this->contents)) {
                        foreach ($this->contents as $products_id => $value) {
                            $cat_query = xtc_db_query(
                                "SELECT products_id
														FROM products_to_categories
														WHERE
															products_id = '" . $products_id . "' AND
															categories_id = '" . $cat_ids[$i] . "'"
                            );
                            if (xtc_db_num_rows($cat_query) != 0) {
                                $in_cat      = true;
                                $total_price += $this->get_product_price($products_id);
                            }
                        }
                    }
                }
            }
            
            $in_cart = true;
            $pr_ids = $this->parseIdList($couponDetails['restrict_to_products']);
			if(!empty($pr_ids))
			{
				$in_cart = false;
				$total_price = 0.0;
				$products_array = $_SESSION['cart']->get_products();

				for($i = 0, $iMax = count($pr_ids); $i < $iMax; $i++)
				{
					for($ii = 1, $iiMax = count($products_array); $ii <= $iiMax; $ii++)
					{
						if((int)xtc_get_prid($products_array[$ii - 1]['id']) === (int)$pr_ids[$i])
						{
							$in_cart = true;
							$total_price += $this->get_product_price($products_array[$ii - 1]['id']);
						}
					}
				}

				$order_total = $total_price;
			}
		}

		return $order_total;
	}

	public function get_product_price($product_id)
	{
        $order   = $GLOBALS['order'];
        $xtPrice = $GLOBALS['xtPrice'];
        
        $total_price        = 0.0;
        $qty                = $_SESSION['cart']->contents[$product_id]['qty'];
        $basket_products_id = $product_id;
        $products_id        = xtc_get_prid($product_id);
        
        // products price
        $product_query = xtc_db_query(
            'SELECT
                products_id,
                products_price,
                products_tax_class_id,
                products_weight
            FROM ' . TABLE_PRODUCTS . "
            WHERE products_id='" . (int)$products_id . "'"
        );
        if (xtc_db_num_rows($product_query) > 0) {
            $product = xtc_db_fetch_array($product_query);
            $prid    = $product['products_id'];
            
            if ($this->include_tax === 'true') {
                $productsTaxClassId = $product['products_tax_class_id'];
            } else {
                $productsTaxClassId = 0;
            }
            $total_price += $qty * $xtPrice->xtcGetPrice(
                    $basket_products_id,
                    $format = false,
                    1,
                    $productsTaxClassId,
                    $product['products_price'],
                    1,
                    0,
                    true,
                    true
                );
            
            $products_tax = $xtPrice->TAX[$product['products_tax_class_id']];
            
            // attributes price
            if (isset($_SESSION['cart']->contents[$product_id]['attributes'])) {
                foreach ($_SESSION['cart']->contents[$product_id]['attributes'] as $option => $value) {
                    $attribute_price_query = xtc_db_query(
                        'SELECT
                            options_values_price,
                            price_prefix
                        FROM ' . TABLE_PRODUCTS_ATTRIBUTES . "
                        WHERE
                            products_id = '" . $prid . "' AND
                            options_id = '" . $option . "' AND
                            options_values_id = '" . $value . "'"
                    );
                    $attribute_price       = xtc_db_fetch_array($attribute_price_query);
                    
                    if ($attribute_price['price_prefix'] === '+') {
                        if ($this->include_tax === 'true') {
                            $total_price += $qty * ($attribute_price['options_values_price'] + xtc_calculate_tax(
                                        $attribute_price['options_values_price'],
                                        $products_tax
                                    ));
                        } else {
                            $total_price += $qty * $attribute_price['options_values_price'];
                        }
                    } elseif ($this->include_tax === 'true') {
                        $total_price -= $qty * ($attribute_price['options_values_price'] + xtc_calculate_tax(
                                    $attribute_price['options_values_price'],
                                    $products_tax
                                ));
                    } else {
                        $total_price -= $qty * $attribute_price['options_values_price'];
                    }
                }
            }
        }
        
        if((int)$_SESSION['customers_status']['customers_status_ot_discount_flag'] === 1)
		{
			$total_price -= $total_price / 100 * $_SESSION['customers_status']['customers_status_ot_discount'];
		}

		if($this->include_shipping === 'true')
		{
			$total_price += $order->info['shipping_cost'];
		}

		return $total_price;
	}
    
    
    public function product_price($product_id)
    {
        $order       = $GLOBALS['order'];
        $total_price = $this->get_product_price($product_id);
    
        if (strtolower($this->include_shipping) === 'true') {
            $total_price -= $order->info['shipping_cost'];
        }
        
        return $total_price;
    }
    
    
    public function check()
    {
        if (!isset($this->check)) {
            $check_query = xtc_db_query(
                'SELECT `value` FROM `gx_configurations`'
                . " WHERE `key` = 'configuration/MODULE_ORDER_TOTAL_COUPON_STATUS'"
            );
            $this->check = xtc_db_num_rows($check_query);
        }
        
        return $this->check;
    }
    
    
    public function keys(): array
    {
        return [
            'configuration/MODULE_ORDER_TOTAL_COUPON_STATUS',
            'configuration/MODULE_ORDER_TOTAL_COUPON_SORT_ORDER',
            'configuration/MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING',
            'configuration/MODULE_ORDER_TOTAL_COUPON_INC_TAX',
            'configuration/MODULE_ORDER_TOTAL_COUPON_CALC_TAX',
            'configuration/MODULE_ORDER_TOTAL_COUPON_TAX_CLASS',
            'configuration/MODULE_ORDER_TOTAL_COUPON_SHOW_INFO',
        ];
    }
    
    
    public function install(): void
    {
        xtc_db_query(
            "INSERT INTO `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`, `type`) VALUES ('configuration/MODULE_ORDER_TOTAL_COUPON_STATUS', 'true', '6', '1', 'switcher')"
        );
        xtc_db_query(
            "INSERT INTO `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`) VALUES ('configuration/MODULE_ORDER_TOTAL_COUPON_SORT_ORDER', '70', '6', '2')"
        );
        xtc_db_query(
            "INSERT INTO `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`, `type`) VALUES ('configuration/MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING', 'true', '6', '5', 'switcher')"
        );
        xtc_db_query(
            "INSERT INTO `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`, `type`) VALUES ('configuration/MODULE_ORDER_TOTAL_COUPON_INC_TAX', 'true', '6', '6','swticher')"
        );
        xtc_db_query(
            "INSERT INTO `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`, `type`) VALUES ('configuration/MODULE_ORDER_TOTAL_COUPON_CALC_TAX', 'None', '6', '7','tax-calculation-mode')"
        );
        xtc_db_query(
            "INSERT INTO `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`, `type`) VALUES ('configuration/MODULE_ORDER_TOTAL_COUPON_TAX_CLASS', '0', '6', '0', 'tax-class')"
        );
        xtc_db_query(
            "INSERT INTO `gx_configurations` (`key`, `value`, `legacy_group_id`, `sort_order`, `type`) VALUES ('configuration/MODULE_ORDER_TOTAL_COUPON_SHOW_INFO', 'false', '6', '9','switcher')"
        );
        
        xtc_db_query(
            "UPDATE `gx_configurations` SET `value` = 'true' WHERE `key` = 'configuration/MODULE_ORDER_TOTAL_GV_INC_SHIPPING'"
        );
    }
    
    
    public function remove()
    {
        $keys       = '';
        $keys_array = $this->keys();
        
        for ($i = 0, $iMax = sizeof($keys_array); $i < $iMax; $i++) {
            $keys .= "'" . $keys_array[$i] . "',";
        }
        
        $keys = substr($keys, 0, -1);
        
        xtc_db_query("DELETE FROM `gx_configurations` WHERE `key` IN (" . $keys . ")");
    }
    
}

MainFactory::load_origin_class('ot_coupon');
